#gencode.vM23.annotation.gtf annotation file to find genes producing dsRNA and siRNA - https://www.gencodegenes.org/mouse/

#remove top row
grep -v "##" gencode.vM23.annotation.gtf > grep.gtf

#Fill Blank ID's
awk '{ if ($0 ~ "transcript_id") print $0; else print $0" transcript_id \"\";"; }' grep.gtf > grep.gtf

#UCreate bedfile - https://bedops.readthedocs.io/en/latest/content/reference/file-management/conversion/gtf2bed.html
gencode.vM23.annotation.gtf | gtf2bed - > mousegenes.bed

#Intersect - https://bedtools.readthedocs.io/en/latest/content/tools/intersect.html
bedtools intersect -a mousegenes.bed -b R_all.merged.bed -wa > dsRNA_genes.bed

#Find genes
awk '$8 == "gene"' dsRNA_genes.bed > gene.bed

#Remove genes with 0 alignments
awk '”$11>"0"' dsRNA_genes.bed > gene.bed


